* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)




# 922. 按奇偶排序数组II

[力扣题目链接](https://leetcode.cn/problems/sort-array-by-parity-ii/)

给定一个非负整数数组 nums， nums 中一半整数是奇数，一半整数是偶数。

对数组进行排序，以便当 nums[i] 为奇数时，i 也是奇数；当 nums[i] 为偶数时， i 也是偶数。

你可以返回任何满足上述条件的数组作为答案。

示例：

* 输入：[4,2,5,7]
* 输出：[4,5,2,7]
* 解释：[4,7,2,5]，[2,5,4,7]，[2,7,4,5] 也会被接受。


## 思路

这道题目直接的想法可能是两层for循环再加上used数组表示使用过的元素。这样的的时间复杂度是O(n^2)。

### 方法一

其实这道题可以用很朴实的方法，时间复杂度就就是O(n)了，C++代码如下：

```CPP
class Solution {
public:
    vector<int> sortArrayByParityII(vector<int>& nums) {
        vector<int> even(nums.size() / 2); // 初始化就确定数组大小，节省开销
        vector<int> odd(nums.size() / 2);
        vector<int> result(nums.size());
        int evenIndex = 0;
        int oddIndex = 0;
        int resultIndex = 0;
        // 把nums数组放进偶数数组，和奇数数组
        for (int i = 0; i < nums.size(); i++) {
            if (nums[i] % 2 == 0) even[evenIndex++] = nums[i];
            else odd[oddIndex++] = nums[i];
        }
        // 把偶数数组，奇数数组分别放进result数组中
        for (int i = 0; i < evenIndex; i++) {
            result[resultIndex++] = even[i];
            result[resultIndex++] = odd[i];
        }
        return result;
    }
};
```

* 时间复杂度：O(n)
* 空间复杂度：O(n)

### 方法二

以上代码我是建了两个辅助数组，而且nums数组还相当于遍历了两次，用辅助数组的好处就是思路清晰，优化一下就是不用这两个辅助数组，代码如下：

```CPP
class Solution {
public:
    vector<int> sortArrayByParityII(vector<int>& nums) {
        vector<int> result(nums.size());
        int evenIndex = 0;  // 偶数下标
        int oddIndex = 1;   // 奇数下标
        for (int i = 0; i < nums.size(); i++) {
            if (nums[i] % 2 == 0) {
                result[evenIndex] = nums[i];
                evenIndex += 2;
            }
            else {
                result[oddIndex] = nums[i];
                oddIndex += 2;
            }
        }
        return result;
    }
};
```

* 时间复杂度：O(n)
* 空间复杂度：O(n)

### 方法三

当然还可以在原数组上修改，连result数组都不用了。

```CPP
class Solution {
public:
    vector<int> sortArrayByParityII(vector<int>& nums) {
        int oddIndex = 1;
        for (int i = 0; i < nums.size(); i += 2) {
            if (nums[i] % 2 == 1) { // 在偶数位遇到了奇数
                while(nums[oddIndex] % 2 != 0) oddIndex += 2; // 在奇数位找一个偶数
                swap(nums[i], nums[oddIndex]); // 替换
            }
        }
        return nums;
    }
};
```

* 时间复杂度：O(n)
* 空间复杂度：O(1)

这里时间复杂度并不是O(n^2)，因为偶数位和奇数位都只操作一次，不是n/2 * n/2的关系，而是n/2 + n/2的关系！


## 其他语言版本

### Java

```java
// 方法一
class Solution {
    public int[] sortArrayByParityII(int[] nums) {
        // 分别存放 nums 中的奇数、偶数
        int len = nums.length;
        int evenIndex = 0;
        int oddIndex = 0;
        int[] even = new int[len / 2];
        int[] odd = new int[len / 2];
        for (int i = 0; i < len; i++) {
            if (nums[i] % 2 == 0) {
                even[evenIndex++] = nums[i];
            } else {
                odd[oddIndex++] = nums[i];
            }
        }
        // 把奇偶数组重新存回 nums
        int index = 0;
        for (int i = 0; i < even.length; i++) {
            nums[index++] = even[i];
            nums[index++] = odd[i];
        }
        return nums;
    }
}
```

```java
//方法一：采用额外的数组空间
class Solution {
    public int[] sortArrayByParityII(int[] nums) {
        //定义结果数组 result
        int[] result = new int[nums.length];
        int even = 0, odd = 1;
        for(int i = 0; i < nums.length; i++){
            //如果为偶数
            if(nums[i] % 2 == 0){
                result[even] = nums[i];
                even += 2;
            }else{
                result[odd] = nums[i];
                odd += 2;
            }
        }
        return result;
    }
}
```
```java
//方法二：不采用额外的数组空间
class Solution922 {
    public int[] sortArrayByParityII(int[] nums) {
        //定义双指针
        int oddPoint = 1, evenPoint = 0;
        //开始移动并交换，最后一层必然为相互交换后再移动或者相同直接移动
        while(oddPoint < nums.length && evenPoint < nums.length){
            //进行判断
            if(nums[oddPoint] % 2 == 0 && nums[evenPoint] % 2 == 1){    //如果均不满足
                int temp = 0;
                temp = nums[oddPoint];
                nums[oddPoint] = nums[evenPoint];
                nums[evenPoint] = temp;
                oddPoint += 2;
                evenPoint += 2;
            }else if(nums[oddPoint] % 2 == 0 && nums[evenPoint] % 2 == 0){  //偶数满足
                evenPoint += 2;
            }else if(nums[oddPoint] % 2 == 1 && nums[evenPoint] % 2 == 1){  //奇数满足
                oddPoint += 2;
            }else{
                oddPoint += 2;
                evenPoint += 2;
            }
        }
        return nums;
    }
}
```

### Python3

```python
#方法2
class Solution:
    def sortArrayByParityII(self, nums: List[int]) -> List[int]:
        result = [0]*len(nums)
        evenIndex = 0
        oddIndex = 1
        for i in range(len(nums)):
            if nums[i] % 2: #奇数
                result[oddIndex] = nums[i]
                oddIndex += 2
            else: #偶数
                result[evenIndex] = nums[i]
                evenIndex += 2
        return result

#方法3
class Solution:
    def sortArrayByParityII(self, nums: List[int]) -> List[int]:
        oddIndex = 1
        for i in range(0,len(nums),2): #步长为2
            if nums[i] % 2: #偶数位遇到奇数
                while  nums[oddIndex] % 2: #奇数位找偶数
                    oddIndex += 2
                nums[i], nums[oddIndex] = nums[oddIndex], nums[i]
        return nums
```

### Go

```go

// 方法一
func sortArrayByParityII(nums []int) []int {
	// 分别存放 nums 中的奇数、偶数
	even, odd := []int{}, []int{}
	for i := 0; i < len(nums); i++ {
		if (nums[i] % 2 == 0) {
			even = append(even, nums[i])
		} else {
			odd = append(odd, nums[i])
		}
	}

	// 把奇偶数组重新存回 nums
	result := make([]int, len(nums))
	index := 0
	for i := 0; i < len(even); i++ {
		result[index] = even[i]; index++;
		result[index] = odd[i]; index++;
	}
	return result;
}

// 方法二
func sortArrayByParityII(nums []int) []int {
    result := make([]int, len(nums))
    evenIndex := 0  // 偶数下标
    oddIndex := 1   // 奇数下标
    for _, v := range nums {
        if v % 2 == 0 {
            result[evenIndex] = v
            evenIndex += 2
        } else {
            result[oddIndex] = v
            oddIndex += 2
        }
    }
    return result
}

// 方法三
func sortArrayByParityII(nums []int) []int {
    oddIndex := 1
    for i := 0; i < len(nums); i += 2 {
        if nums[i] % 2 == 1 { // 在偶数位遇到了奇数
            for nums[oddIndex] % 2 != 0 {
                oddIndex += 2 // 在奇数位找一个偶数 
            }
            nums[i], nums[oddIndex] = nums[oddIndex], nums[i]
        }
    }
    return nums
}
```

### JavaScript

```js
//方法一
var sortArrayByParityII = function(nums) {
    const n = nums.length;
    // 分别存放 nums 中的奇数、偶数
    let evenIndex = 0, oddIndex = 0;
    // 初始化就确定数组大小，节省开销
    const even = new Array(Math.floor(n/2));
    const odd = new Array(Math.floor(n/2));
    // 把A数组放进偶数数组，和奇数数组
    for(let i = 0; i < n; i++){
        if(nums[i] % 2 === 0) even[evenIndex++] = nums[i];
        else odd[oddIndex++] = nums[i];
    }
    // 把奇偶数组重新存回 nums
    let index = 0;
    for(let i = 0; i < even.length; i++){
        nums[index++] = even[i];
        nums[index++] = odd[i];
    }
    return nums;
};

//方法二
var sortArrayByParityII = function(nums) {
    const n = nums.length;
    const result = new Array(n);
    // 偶数下标 和 奇数下标
    let evenIndex = 0, oddIndex = 1;
    for(let i = 0; i < n; i++){
        if(nums[i] % 2 === 0) {
            result[evenIndex] = nums[i];
            evenIndex += 2;
        } else {
            result[oddIndex] = nums[i];
            oddIndex += 2;
        }
    }
    return result;
};

//方法三
var sortArrayByParityII = function(nums) {
    let oddIndex = 1;
    for(let i = 0; i < nums.length; i += 2){
        if(nums[i] % 2 === 1){ // 在偶数位遇到了奇数
            while(nums[oddIndex] % 2 !== 0) oddIndex += 2;// 在奇数位找一个偶数
            [nums[oddIndex], nums[i]] = [nums[i], nums[oddIndex]]; // 解构赋值交换
        }
    }
    return nums;
};
```

### TypeScript

> 方法一：

```typescript
function sortArrayByParityII(nums: number[]): number[] {
    const evenArr: number[] = [],
        oddArr: number[] = [];
    for (let num of nums) {
        if (num % 2 === 0) {
            evenArr.push(num);
        } else {
            oddArr.push(num);
        }
    }
    const resArr: number[] = [];
    for (let i = 0, length = nums.length / 2; i < length; i++) {
        resArr.push(evenArr[i]);
        resArr.push(oddArr[i]);
    }
    return resArr;
};
```

> 方法二：

```typescript
function sortArrayByParityII(nums: number[]): number[] {
    const length: number = nums.length;
    const resArr: number[] = [];
    let evenIndex: number = 0,
        oddIndex: number = 1;
    for (let i = 0; i < length; i++) {
        if (nums[i] % 2 === 0) {
            resArr[evenIndex] = nums[i];
            evenIndex += 2;
        } else {
            resArr[oddIndex] = nums[i];
            oddIndex += 2;
        }
    }
    return resArr;
};
```

> 方法三：

```typescript
function sortArrayByParityII(nums: number[]): number[] {
    const length: number = nums.length;
    let oddIndex: number = 1;
    for (let evenIndex = 0; evenIndex < length; evenIndex += 2) {
        if (nums[evenIndex] % 2 === 1) {
            // 在偶数位遇到了奇数
            while (oddIndex < length && nums[oddIndex] % 2 === 1) {
                oddIndex += 2;
            }
            // 在奇数位遇到了偶数，交换
            let temp = nums[evenIndex];
            nums[evenIndex] = nums[oddIndex];
            nums[oddIndex] = temp;
        }
    }
    return nums;
};
```


